---
obsidianUIMode: preview
---

For a typical game session, the Lazy RPG Prep checklist looks like this:

* Review the characters
* Create a strong start
* Outline potential scenes
* Define secrets and clues
* Develop fantastic locations
* Outline important NPCs
* Choose relevant monsters
* Select magic item rewards

Here's a brief summary of each of the steps.

## Review the Characters

Before we do anything else, it helps to spend a few minutes reviewing the player characters. What are their names? What do they want? What plays into their backgrounds? What do the players of these characters enjoy at the table?

You might not even write anything down during this step, but reviewing the characters helps wire them into your mind — and ensures that the rest of your preparation fits around them.

## Create a Strong Start

How a game starts is likely the most important piece of preparation we can do. Setting the stage for the session determines a great deal about how the rest of the game will go. When you define where a game session starts, you figure out what's going on, what the initial focus of the session is, and how you can get close to the action. When in doubt, start with a fight. Example strong starts can be found later in this document.

## Outline Potential Scenes

With a strong start in hand, we can then outline a short list of potential scenes that might unfold. This step exists mostly to make you feel as though you have a handle on the game before you start. However, as GMs, all of us must always be ready to throw our potential scenes away when the game goes in a different direction — as it often does. Usually, it's enough to come up with only a few words per scene, and to expect one or two scenes per hour of play. At other times, you might skip this step completely if you don't think you need it.

## Define Secrets and Clues

The next step is second only in importance to the strong start, and is one of the most powerful tools available to GMs. Secrets and clues are single short sentences that describe a clue, a piece of the story, or a piece of the world that the characters can discover during the game. You don't know exactly *how* the characters will discover these clues. As such, you'll want to **keep these secrets and clues abstract from their place of discovery** so that you can drop them into the game wherever it makes sense. This lets the game flow freely, while still allowing you to reveal important pieces of the story at any point where the characters might discover them. During this step, you might write down ten such secrets or clues. Example secrets and clues are offered later in this document.

## Develop Fantastic Locations

Building evocative locations isn't easily improvised. As such, it's worth spending time writing out a handful of fantastic locations that the characters might discover and explore during the game. Each location can be thought of as a set, a room, or a backdrop for a single scene in your adventure.

Describe each location with a short evocative title such as "The Sunspire." Then write down three fantastic aspects for it, along the lines of: "Blazing beam of light shining to the heavens," "Moat of molten rock," or "Huge elven glyphs carved into ancient stone." Ultimately, whole dungeons can be built from a series of connected fantastic locations, with each location representing a large area or chamber. A specific location might not come up during the game for which you prepare it, but it will be ready for a later session as the characters explore.

## Outline Important NPCs

During our preparation, we'll outline those NPCs (nonplayer characters) most critical to the adventure, focusing on a name and a connection to the adventure, then wrapping the NPC in a character archetype from popular fiction. Many other NPCs — maybe even most of them — can be improvised right at the table.

## Choose Relevant Monsters

What monsters are the characters most likely to face? What monsters make sense for a specific location and situation? We're using the term "monster" loosely here, so as to include enemy NPCs as well as truly monstrous foes. Whatever type of enemy you need, reading through books of monsters can give you the fuel to choose the right creatures for the right situation.

Additionally, understanding the loose relationship between monster challenge rating and character level can help you understand how a battle might go. Most of the time, you can just list a number of monsters and improvise encounters based on what's happening in the adventure. For boss battles, you might have to do more work. See [Lazy Combat Encounter Building](<15 - Lazy Combat Encounter Building for 5e.md>) for more information.

## Select Magic Item Rewards

Players love magic items, and it's worthwhile to spend time preparing items they'll find interesting. This step also helps to directly impact the characters — by dropping an interesting part of the story literally into their hands. You can use a mixture of techniques to reward magic items, from selecting items randomly to selecting specific items based on the themes of the characters and the desires of the players. Magic items are also a great mechanism for delivering secrets and clues.

## The Lazy RPG Prep Checklist and Online Play

These steps and processes work just as well whether you interact with your players online or around the table. However you play, the Lazy RPG Prep checklist still works.

## The 5-Minute Reduced Checklist

If you have very little time, reduce the checklist to the most important things you can prepare before it's time to run the game. Here are three example steps.

* Create a strong start
* Define secrets and clues
* Develop fantastic locations
